﻿using Microsoft.Web.Http;
using PpmsDataService.Models;
using PpmsDataService.V1.Mappers;
using PpmsDataService.VA.PPMS.Context;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Threading.Tasks;
using System.Web;
using System.Web.Http;
using System.Web.Http.Description;
using System.Web.OData;
using System.Web.OData.Routing;
using VA.PPMS.Context;

namespace PpmsDataService.V1.Controllers
{
    [EnableQuery]
    //[Authorize]
    [ApiVersion("1.0")]
    public class VisnsController : ODataController
    {
        [ODataRoute("Visns('{key}')")]
        public async Task<HttpResponseMessage> Get(string key)
        {
            //We will use the Query type found in URL to determine if Expanded properties need to be mapped. 
            var queryType = HttpContext.Current.Request.Url.Query;

            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Retrieve the Visn 
                var ppmsVisn = context.va_visnSet.FirstOrDefault(i => i.va_name.Contains(key));
                if (ppmsVisn != null)
                {
                    var ppmsVisnsList = new List<va_visn> { ppmsVisn };
                    var visns = await VisnMap.MapVisns(ppmsVisnsList, queryType, context);
                    return Request.CreateResponse(visns);
                }
            }
            var message = string.Format("Visn with Name: {0} not found", key);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }
   
        [ODataRoute("Visns('{key}')/Facilities")]
        public async Task<HttpResponseMessage> GetFacilties([FromODataUri] string key)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Retrieve the Visn 
                var ppmsVisn = context.va_visnSet.FirstOrDefault(i => i.va_name.Contains(key));
                if (ppmsVisn != null)
                {
                    var ppmsFacilities =
                        context.va_facilitySet.Where(i => i.va_visnid.Id == ppmsVisn.Id);
                    var ppmsFacilitiesList = ppmsFacilities.ToList();
                    var facilities =
                        await FacilityMap.MapFacilities(ppmsFacilitiesList, "None", context);
                    return Request.CreateResponse(facilities);
                }
            }
            var message = string.Format("Facilities with Visn Name: {0} not found", key);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("Visns('{key}')/CareSites")]
        public async Task<HttpResponseMessage> GetCareSites([FromODataUri] string key)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Retrieve the Visn 
                var ppmsVisn = context.va_visnSet.FirstOrDefault(i => i.va_name.Contains(key));
                if (ppmsVisn != null)
                {
                    var ppmsCareSites =
                        context.ppms_caresiteSet.Where(i => i.ppms_visnid.Id == ppmsVisn.Id);
                    var ppmsCareSitesList = ppmsCareSites.ToList();
                    var careSites =
                        await CareSiteMap.MapCareSites(ppmsCareSitesList, "None", context);
                    return Request.CreateResponse(careSites);
                }
            }
            var message = string.Format("Care Sites with Visn Name: {0} not found", key);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("Visns('{key}')/Institutions")]
        public async Task<HttpResponseMessage> GetInstitutions([FromODataUri] string key)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Retrieve the Visn 
                var ppmsVisn = context.va_visnSet.FirstOrDefault(i => i.va_name.Contains(key));
                if (ppmsVisn != null)
                {
                    var ppmsInstitutions =
                        context.ppms_institutionSet.Where(i => i.ppms_visn.Id == ppmsVisn.Id);
                    var ppmsInstitutionsList = ppmsInstitutions.ToList();
                    var insitutions =
                        await InstitutionMap.MapInstitutions(ppmsInstitutionsList, "None", context);
                    return Request.CreateResponse(insitutions);
                }
            }
            var message = string.Format("Institutions with Visn Name: {0} not found", key);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [HttpGet]
        [MapToApiVersion("1.0")]
        [ResponseType(typeof(Visn))]
        [ODataRoute("GetVisnByName")]
        public async Task<HttpResponseMessage> GetVisnByName([FromODataUri] string visnName)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {

                var ppmsVisns = context.va_visnSet.Where(i => i.ppms_visnname.Contains(visnName));
                var ppmsVisnsList = ppmsVisns.ToList();
                if (ppmsVisnsList.Any())
                {
                    //Map Visns
                    var visns = await VisnMap.MapVisns(ppmsVisnsList, "None", context);
                    return Request.CreateResponse(visns);
                }
                var message = string.Format("Visns containing name: {0} not found", visnName);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
            }
        }

        [HttpGet]
        [MapToApiVersion("1.0")]
        [ResponseType(typeof(Visn))]
        [ODataRoute("GetVisnByNumber")]
        public async Task<HttpResponseMessage> GetVisnByNumber([FromODataUri] string visnNumber)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {

                var ppmsVisns = context.va_visnSet.Where(i => i.va_name.Contains(visnNumber));
                var ppmsVisnsList = ppmsVisns.ToList();
                if (ppmsVisnsList.Any())
                {
                    //Map Visns
                    var visns = await VisnMap.MapVisns(ppmsVisnsList, "None", context);
                    return Request.CreateResponse(visns);
                }
                var message = string.Format("Visns containing Visn Number: {0} not found", visnNumber);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
            }
        }

        [ODataRoute("Visns")]
        public async Task<HttpResponseMessage> Get()
        {
            //This Scenario returns the first 50 Visns in the system. . 
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsVisns = context.va_visnSet.Where(i => i.va_name != null).Take(50);
                var ppmsVisnsList = ppmsVisns.ToList();
                if (ppmsVisnsList.Any())
                {
                    //Map Visns
                    var visns = await VisnMap.MapVisns(ppmsVisnsList, "None", context);
                    return Request.CreateResponse(visns);
                }
                var message = "Visns Not Found";
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }
    }
}